<?php
/*
Plugin Name: Negarara
Plugin URI: https://ertano.com/negarara/
Description: Convert uploaded images to WebP format with customizable quality settings.
Version: 2.0.0
Author: Ertano
Author URI: https://ertano.com
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: negarara
Domain Path: /languages
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
define('NEAGARARA_DIR_URL', plugin_dir_url(__FILE__));
define('NEAGARARA_DIR_PATH', plugin_dir_path(__FILE__));
function negarara_load_textdomain() {
    load_plugin_textdomain('negarara', false, dirname(plugin_basename(__FILE__)) . '/languages');
}
add_action('plugins_loaded', 'negarara_load_textdomain');
require_once NEAGARARA_DIR_PATH . 'includes/class-negarara-converter.php';
require_once NEAGARARA_DIR_PATH . 'admin/class-negarara-admin.php';
new Negarara_Admin();
new Negarara_Converter();
function negarara_handleUpdater() {
    if (file_exists(NEAGARARA_DIR_PATH . 'mihanwpUpdater.php')) {
        include_once NEAGARARA_DIR_PATH . 'mihanwpUpdater.php';
        $plugin_data = get_file_data(__FILE__, ['Version' => 'Version'], false);
        $plugin_version = $plugin_data['Version'];

        $updaterArgs = [
            'base_api_server' => 'https://mihanwp.com',
            'license_key'     => 'free',
            'item_id'         => 1152552,
            'current_version' => $plugin_version,
            'plugin_slug'     => plugin_basename(__FILE__),
            'license_status'  => true,
        ];
        \Negarara\mihanwpUpdater::init($updaterArgs);
    }
}
add_action('plugins_loaded', 'negarara_handleUpdater');