<?php if (!defined('ABSPATH')) exit; ?>
<div class="ehm-feature-list ehm-color-<?php echo esc_attr($data['color']); ?>">
    
    <?php if (!empty($data['image'])): ?>
        <img src="<?php echo esc_url($data['image']); ?>" alt="<?php echo esc_attr($data['title']); ?>">
    <?php endif; ?>

    <div>
        <?php if (!empty($data['title'])): ?>
            <h3><?php echo esc_html($data['title']); ?></h3>
        <?php endif; ?>

        <?php
        $features_source = '';
        if (!empty($data['description'])) {
            $features_source = $data['description'];
        } elseif (!empty($data['desc'])) {
            $features_source = $data['desc'];
        }
        ?>

        <?php if (!empty($features_source)): ?>
            <ul>
                <?php foreach (explode('.', $features_source) as $feature): ?>
                    <?php if (trim($feature)): ?>
                        <li><?php echo esc_html(trim($feature)); ?></li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>

    </div>
    <?php if (!empty($data['cta_text']) && !empty($data['permalink'])): ?>
        <a href="<?php echo esc_url($data['permalink']); ?>" class="ehm-cta-button" target="_blank" rel="noopener">
            <?php if (!empty($data['icon']) && $data['icon_position'] === 'left'): ?>
                <span class="dashicons <?php echo esc_attr($data['icon']); ?>" style="vertical-align:middle; margin-right:5px;"></span>
            <?php endif; ?>
            
            <?php echo esc_html($data['cta_text']); ?>
            
            <?php if (!empty($data['icon']) && $data['icon_position'] === 'right'): ?>
                <span class="dashicons <?php echo esc_attr($data['icon']); ?>" style="vertical-align:middle; margin-left:5px;"></span>
            <?php endif; ?>
        </a>
    <?php endif; ?>
</div>
