<?php if (!defined('ABSPATH')) exit; ?>
<div class="ehm-card ehm-color-<?php echo esc_attr($data['color']); ?>">

    <?php if (!empty($data['image'])): ?>
        <img src="<?php echo esc_url($data['image']); ?>" alt="<?php echo esc_attr($data['title']); ?>">
    <?php endif; ?>

    <?php if (!empty($data['title'])): ?>
        <h3><?php echo esc_html($data['title']); ?></h3>
    <?php endif; ?>

    <p>
        <?php
        if (!empty($data['description'])) {
            echo esc_html($data['description']);
        } elseif (!empty($data['desc'])) {
            echo esc_html($data['desc']);
        }
        ?>
    </p>

    <?php
    if (
        (isset($data['source']) && $data['source'] === 'wc-local')
        &&
        (
            !empty($data['price'])
            || !empty($data['regular_price'])
            || !empty($data['sale_price'])
        )
    ): ?>
        <div class="ehm-product-prices" style="margin-bottom:10px;">
            <?php if (!empty($data['regular_price'])): ?>
                <span class="ehm-regular-price" style="color:#777; text-decoration:line-through; margin-left:5px;">
                    <?php echo number_format($data['regular_price'], 0, '.', ','); ?> تومان
                </span>
            <?php endif; ?>
            <?php if (!empty($data['sale_price'])): ?>
                <span class="ehm-sale-price" style="color:#c00; font-weight:bold;">
                    <?php echo number_format($data['sale_price'], 0, '.', ','); ?> تومان
                </span>
            <?php elseif (!empty($data['price'])): ?>
                <span class="ehm-final-price" style="color:#222; font-weight:bold;">
                    <?php echo number_format($data['price'], 0, '.', ','); ?> تومان
                </span>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($data['cta_text']) && !empty($data['permalink'])): ?>
        <a href="<?php echo esc_url($data['permalink']); ?>" class="ehm-cta-button" target="_blank" rel="noopener">
            <?php
            if (!empty($data['icon']) && $data['icon_position'] === 'left'): ?>
                <span class="dashicons <?php echo esc_attr($data['icon']); ?>" style="vertical-align:middle; margin-right:5px;"></span>
            <?php endif; ?>
            <?php echo esc_html($data['cta_text']); ?>
            <?php
            if (!empty($data['icon']) && $data['icon_position'] === 'right'): ?>
                <span class="dashicons <?php echo esc_attr($data['icon']); ?>" style="vertical-align:middle; margin-left:5px;"></span>
            <?php endif; ?>
        </a>
    <?php endif; ?>
</div>
